#!/bin/bash

APP_NAME="TimoDesk"
APP_FILE="TimoDesk-1.0.6.AppImage"
ICON_URL="https://timodesk.com/assets/images/logo/favicon.png"
ICON_PATH="$HOME/.local/share/icons/timodesk.png"
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

echo "Installing $APP_NAME..."

mkdir -p ~/Applications
mkdir -p ~/.local/share/icons

# Copy and make executable
if [ -f "$SCRIPT_DIR/$APP_FILE" ]; then
    cp "$SCRIPT_DIR/$APP_FILE" ~/Applications/
    chmod +x ~/Applications/"$APP_FILE"
else
    echo "Error: $APP_FILE not found."
    exit 1
fi

# Download icon
wget -q -O "$ICON_PATH" "$ICON_URL"

# what is the problem here bruh :)
cat <<EOF > ~/.local/share/applications/"${APP_NAME,,}.desktop"
[Desktop Entry]
Name=$APP_NAME
Exec=$HOME/Applications/$APP_FILE --no-sandbox
Icon=$ICON_PATH
Type=Application
Categories=Utility;
Terminal=false
EOF

update-desktop-database ~/.local/share/applications/ 2>/dev/null

echo "Installation complete! The --no-sandbox flag has been added automatically."